jQuery(function($) {

	var $document = $(document),
			$window = $(window),
			$body = $(document.body);

	var root = location.pathname.split('/');
	root.length -= 2;
	root = root.join('/');

	// put admin inside a div#wpwrap
	var $wpwrap = $('<div id="wpwrap">').appendTo($body);
	$wpwrap.siblings().appendTo($wpwrap);

	// remove message param from URL
	var message = location.href.match(/&message=[^&]*/);
	if (message && history.pushState) {
		history.pushState('', '', location.pathname + location.search.replace(message[0], ''));
	}

	// Update sliders per page fix
	$('#ls-screen-options-form').submit(function(e) {
		e.stopPropagation();
		var options = {};
		$(this).find('input').each(function() {
			if( $(this).is(':checkbox')) {
				options[$(this).attr('name')] = $(this).prop('checked');
			} else {
				options[$(this).attr('name')] = $(this).val();
			}
		});

		// Save settings
		$.post(ajaxurl, $.param({ action : 'ls_save_screen_options', options : options }), function() {
			if(typeof reload != "undefined" && reload === true) {
				location.href = location.href;
			}
		});
	});

	// [post-url] override
	$('#ls-layers > .ls-box').on('click', '.ls-slide-link a', function(e) {
		e.preventDefault();
		e.stopPropagation();
		jQuery(this).closest('.ls-slide-link').find('input').val('[url]').trigger('input').trigger('change');
	});

	// filtering sliders fix
	$('<input>', {name: 'option', value: 'com_layer_slider', type: 'hidden'}).prependTo('#ls-slider-filters');

	// autoplay revisions video fix
	$('#ls-revisions-welcome video[autoplay]').each(function() { this.play() });

	// Import sample sliders
	$('#ls-import-samples-button').click(function(e) {
		e.stopImmediatePropagation();
		e.preventDefault();
		var popup = $('#ls-import-sliders-template');
		if (!popup.length) popup = $('<div id="ls-import-sliders-template">').appendTo($body);
		var top = $('#screen-meta-links').offset().top;
		popup.attr('style', 'position: fixed !important;').css({
			top : top,
			opacity: 0,
			width: '100%',
			height: 'calc(100vh - '+top+'px)',
			zIndex: 9999991,
			overflowY: 'scroll'
		}).show().animate({ opacity: 1 }, 300);

		popup.on('click', '.ls-import-close', function() {
			popup.hide();
			$body.css('overflow', '').off('keyup.lsimport');
		});

		$body.css('overflow', 'hidden').on('keyup.lsimport', function(e) {
			if (e.keyCode == 27) $('.ls-import-close').click();
		});

		if (!popup.children().length) {
			$.ajax({
				url: location.protocol+'//offlajn.com/layerslider/',
				dataType: 'jsonp',
				success: function(data) {
					data.css.forEach(function(src) {
						$('<link type="text/css" rel="stylesheet">')
							.appendTo(document.head)
							.attr('href', src);
					});
					popup.html(data.html);
					popup.children().css('min-height', '100%'); // css fix
					var $x = $('<i class="flaticon-delete ls-import-close">').css({color: '#2f3d46', top: 10}).appendTo(popup);
					popup.scroll(function() { $x.css('top', popup.scrollTop() + 10) });
					$.ajax(data.js[0], {
						dataType: 'script',
						cache: true,
						complete: function() {
							popup.find('.filter-options').css('visibility', ''); // reveal tags
							$.getScript(location.protocol+'//offlajn.com/index2.php?option=com_ls_import&task=request&slider=test'); // check domain
						}
					});
				},
				error: function() {
					console.log(arguments)
				}
			});
			popup.on('click', 'a[data-import]', function onImport() {
				var $figure = $(this).closest('figure').addClass('loading');
				$('.logoload').css({
					position: 'absolute',
					display: 'block',
					opacity: 1
				}).appendTo($figure);
				$.getScript(location.protocol+'//offlajn.com/index2.php?option=com_ls_import&task=request&ver='+lsVersion+'&slider='+$(this).data('import'));
			});
			var slideDur = 400;
			popup.on('click', '.ls-warning-close', function closeWarning() {
				$(this).closest('.ls-warning-cont').slideUp(slideDur, function() { $(this).remove() });
			});
			function scrollUp() {
				var scroll = { y: popup.scrollTop() };
				scroll.y && TweenLite.to(scroll, 0.3, { y: 0, onUpdate: function() { popup.scrollTop(scroll.y) } });
			}
			window.lsImportError = function(msg) {
				scrollUp();
				$('.ls-warning-close').click();
				$('figure.loading').removeClass('loading').find('.logoload').hide();
				$('<div class="ls-warning-cont"><h3 class="flaticon-warning">' +
					'<p>'+msg+'</p><i class="flaticon-delete ls-warning-close"/>')
					.insertBefore('#grid').slideUp(0).slideDown(slideDur);
			};
			window.lsImportRegister = function(domain) {
				scrollUp();
				$('.ls-warning-close').click();
				$('figure.loading').removeClass('loading').find('.logoload').hide();
				$('<div class="ls-warning-cont"><h3 class="flaticon-warning">' +
					'<p>Please register your domain to use the import feature!</p>' +
					'<a class="ls-warning-close" href="http://offlajn.com/register-ls-domain/?domain='+domain+'" target="_blank">Register</a>')
					.insertBefore('#grid').slideUp(0).slideDown(slideDur);
			};
			window.lsImportRenew = function() {
				scrollUp();
				$('.ls-warning-close').click();
				$('figure.loading').removeClass('loading').find('.logoload').hide();
				$('<div class="ls-warning-cont"><h3 class="flaticon-warning">' +
					'<p>Import service access has expired<br/><span>Please renew your subscription to use it!</span></p>' +
					'<a class="ls-warning-close" href="http://offlajn.com/download-area/" target="_blank">Renew</a>')
					.insertBefore('#grid').slideUp(0).slideDown(slideDur);
			};
		}
	});

	// embed slider fix
	var embedSlider = function(a) {
		a.href = 'index.php?option=com_modules&task=module.add&eid='+lsModule.eid+'&params[slider]='+$(a).data('id');
		a.target = '_blank';
	};
	$('.ls-sliders-grid').on('click', 'a.embed', function(e) {
		e.stopImmediatePropagation();
		embedSlider(this);
	});

	// update slider action links
	$('#ls-slider-actions-template').on('click', 'a', function(e) {
		if ($(this).hasClass('embed')) {
			e.stopImmediatePropagation();
			embedSlider(this);
		} else {
			this.href = this.href.replace('page=layerslider', 'option=com_layer_slider');
			this.href = this.href.replace('admin.php?page=ls-revisions', 'index.php?option=com_layer_slider&view=revisions');
		}
	});

	// add module assignements to list view
	var $list = $('.ls-sliders-list');
	if ($list.length && location.search.indexOf('view=sliderlist') < 0) {
		var ids = [];
		$('<td>').html('Module assignments').insertBefore($list.find('thead .center'));
		$list.find('tbody .name').each(function() {
			ids[ids.length] = parseInt(this.parentNode.children[1].textContent);
			$('<td class="modpos">').insertAfter(this);
		});

		$.getJSON(ajaxurl, {action: 'ls_get_modules'}, function(data) {
			$list.find('.modpos').each(function(i) {
				lsModule = data;
				var html = '<a class="create_module_tag" href="index.php?option=com_modules&amp;task=module.add&amp;eid='+data.eid+'&amp;params[slider]='+ids[i]+'">Create module</a>';
				for (var j = 0; j < data.modules.length; j++) {
					var mod = data.modules[j];
					if (mod.params.slider == ids[i]) {
						html += '<a href="index.php?option=com_modules&amp;task=module.edit&amp;id='+mod.id+'" class="module_tag '+(mod.published == 1 ? 'published' : 'unpublished')+'">'+mod.title+'</a>';
					}
				}
				this.innerHTML = html;
			});
		});
	} else if (!window.lsSliderData) {
		$.getJSON(ajaxurl, {action: 'ls_get_modules'}, function(data) {
			lsModule = data;
		});
	}
	// replace [] to {} at shortcode
	$list.find('.ls-shortcode').each(function() {
		this.value = '{'+ this.value.slice(1, -1) +'}';
	});

	// open Google fonts tab
	$('.ls-plugin-settings-tabs .active').removeClass('active').next().addClass('active');
	$('.ls-plugin-settings .active').removeClass('active').next().addClass('active');

	// update advanced settings
	var $adv = $('.ls-global-settings');
	if ($adv.length) {
		$.get(ajaxurl, {action: 'ls_get_advanced_settings'}, function($data) {
			$adv.find('tbody').html($data).find(':checkbox').customCheckbox();
		});
	}

	// v5.x compatibility fix: add root to image URLs
	var imgs = '/images/';
	if (root) $('a.preview[style*="('+imgs+'"]').each(function() {
		this.style.backgroundImage = this.style.backgroundImage.replace(/(url\(['"]?)/, '$1'+root);
	});

	if (window.lsSliderData) { // EDIT VIEW

		if (window.LS_img_path_fix) {
			$('<div class="ls-notification large error">').html('<div>'+LS_img_path_fix+'</div>').insertAfter('#ls-screen-options');
			$('.ls-img-path-fix').click(function(e) {
				e.preventDefault();
				kmUI.modal.open( '#tmpl-ls-img-path-fix', { width: 900, height: 1500 } );
			});
			$(document.body).on('click', '.ls-correct-img-path', function() {
				location.href += '&ls-img-path-fix=1';
			});
		}

		// v5.x compatibility fix: add root to image URLs, init thumbs, position fix
		var posFix = false, parallax = {};
		if (lsSliderData.properties) {
			var props = lsSliderData.properties;
			if (props.pauseonhover === true) $('select[name=pauseonhover]').val(props.pauseonhover = 'enabled');
			if (props.pauseonhover === false) $('select[name=pauseonhover]').val(props.pauseonhover = 'disabled');
			if (root && props.backgroundimage && props.backgroundimage.indexOf(imgs) == 0) {
				props.backgroundimage = root + props.backgroundimage;
			}
			props.backgroundimageThumb = props.backgroundimage;
			// slider background compatibility fixes
			if (props.background_size) props.globalBGSize = props.background_size, delete props.background_size;
			if (props.background_repeat) props.globalBGRepeat = props.background_repeat, delete props.background_repeat;
			if (props.background_position) props.globalBGPosition = props.background_position, delete props.background_position;
			if (props.background_behaviour) props.globalBGAttachment = props.background_behaviour, delete props.background_behaviour;
			// fullscreen compatibility fix
			if (props.fullpage && props.forceresponsive && !props.responsive) props.type = 'fullsize', delete props.fullpage;
			if (props.forceresponsive) $('input[name=maxRatio]').val(props.maxRatio = posFix = 1), delete props.forceresponsive;
			// parallax compatibility fix
			if (props.parallaxtype) {
				parallax.event = props.parallaxtype;
				delete props.parallaxtype;
				props.parallaxScrollReverse = true;
				$('input[name=parallaxScrollReverse]').prop('checked', true).next().addClass('on');
			}
			if ('parallaxscrollduration' in props) parallax.scrollduration = props.parallaxscrollduration, delete props.parallaxscrollduration;
		}
		for (var i = 0; i < lsSliderData.layers.length; i++) {
			var slide = lsSliderData.layers[i];
			if (root && slide.properties && slide.properties.background && slide.properties.background.indexOf(imgs) == 0) {
				slide.properties.background = root + slide.properties.background;
			}
			if (parallax.event) {
				slide.properties.parallaxdistance = 40;
				if (parallax.event == 'scroll') {
					slide.properties.parallaxevent = parallax.event;
					slide.properties.parallaxdurationmove = parallax.scrollduration;
				} else {
					slide.properties.parallaxevent = 'cursor';
					slide.properties.parallaxdurationmove = 450;
					slide.properties.parallaxdurationleave = 450;
				}
			}
			slide.properties.backgroundThumb = slide.properties.background;
			for (var j = 0; j < slide.sublayers.length; j++) {
				var layer = slide.sublayers[j];
				if (root && layer.image && layer.image.indexOf(imgs) == 0) {
					layer.image = root + layer.image;
				}
				if (posFix && layer.styles.top.indexOf('%') > 0 && layer.styles.left.indexOf('%') > 0) {
					layer.transition.position = 'fixed';
				}
				layer.imageThumb = layer.image;
			}
		}

		// init slides tab preview
		var i, $tabs = $('#ls-layer-tabs > a');
		for (i = 0; i < lsSliderData.layers.length; i++) {
			var prop = lsSliderData.layers[i].properties;
			var src = prop.backgroundThumb || prop.background;
			if (src) $tabs.eq(i).data('help', '<img src="'+ src +'">');
		}

		// Generate preview immediately
		LS_PostOptions._update = LS_PostOptions.update;
		LS_PostOptions.update = function(el, parsed) {
			clearTimeout(LayerSlider.timeout);
			LayerSlider.generatePreview();
			this._update(el, parsed);
		};

		// dynamic content generator
		var $post = $('#ls-post-options').on('change', '.ls-post-filters select', function() {
			lsSliderData.properties[ $(this).data('param') ] = $(this).val();
			LS_PostOptions.change(this);
		});
		if (~location.search.indexOf('action=edit')) {
			$.getJSON(ajaxurl, {action: 'ls_get_generators'}, function(data) {
				var $header = $post.find('.header');
				$header.contents()[0].textContent = data.header;
				var val, opts = '', type = 'generator_type';
				for (val in data.options) {
					opts += '<option value="'+ val +'">'+ data.options[val] + '</option>';
				}
				var $type = $('<select>', {'class': type, 'data-param': type, 'name': type})
					.html(opts)
					.insertAfter($header)
					.val(lsSliderData.properties.generator_type || 'imagesfromfolder')
					.wrap('<div class="inner clearfix">');
				$('<h3 class="subheader preview-subheader">').html(data.subheader).insertAfter($type.parent());

				$type.change(function() {
					// Get options
					var params = {};
					$post.find('select').each(function() {
						params[ $(this).data('param') ] = $(this).val();
					});
					// update generator type
					lsSliderData.properties.generator_type = $(this).val() || 'imagesfromfolder';

					$.post(ajaxurl, $.param({ action: 'ls_get_dynamic_filters', params: params }), function(data) {
						data = JSON.parse(data);
						// update selects
						$post.find('.ls-post-filters').html(data.filters);
						var $adv = $post.find('.ls-post-adv-settings select');
						$adv[0].innerHTML = $(data.orderby).html();
						var $tpl = $('#ls-layer-template');
						$tpl.html( $tpl.html().replace(/(ls-post-placeholders.*?>)[^]*?<\/ul>/, '$1'+data.taglist+'</ul>') );
						$('.ls-post-placeholders').html(data.taglist);
						// update select values
						$post.find('select').each(function(index) {
							if (index) $(this).val(lsSliderData.properties[ $(this).data('param') ]);
							if (this.selectedIndex < 0) this.selectedIndex = 0;
						});
						// update post options
						LS_PostOptions.change($post[0]);
					});
				}).change();
			});
		}

		// bugfix: zoom slider disappears
		var $zoom = $('.ls-editor-slider').on('slide.bugfix', function() {
			$zoom.parent('.ls-editor-zoom').length || $zoom.off('slide.bugfix').attr('style', '').unwrap();
		});

		// replace [] to {} at shortcode
		$('.ls-save-shortcode span:last-child').each(function() {
			this.innerHTML = '{'+ this.innerHTML.slice(1, -1) +'}';
			return false;
		});

		// session check on save
		$(document).ajaxComplete(function(e, xhr, settings) {
			if (settings.data && settings.data.length && settings.data.indexOf('action=ls_save_slider') === 0) {
				try {
					var resp = JSON.parse(xhr.responseText);
				} catch (ex) {
					adminLogin('Please login at the following popup window, to save your slider', function() { LayerSlider.save() });
				}
			}
		});

	}

	// Skin/CSS Editor
	if(location.href.indexOf('view=skineditor') != -1) {
		$('select[name="skin"]').change(function(e) {
			e.stopImmediatePropagation();
			location.href = 'index.php?option=com_layer_slider&view=skineditor&skin=' + $(this).children(':selected').val();
		});
	}

	/**
	 * Screen Options tab
	 */
	screenMeta = {
		element: null, // #screen-meta
		toggles: null, // .screen-meta-toggle
		page:    null, // #wpcontent

		init: function() {
			this.element = $('#screen-meta');
			this.toggles = $( '#screen-meta-links' ).find( '.show-settings' );
			this.page    = $('#wpcontent');

			this.toggles.click( this.toggleEvent );
		},

		toggleEvent: function() {
			var panel = $( '#' + $( this ).attr( 'aria-controls' ) );

			if ( !panel.length )
				return;

			if ( panel.is(':visible') )
				screenMeta.close( panel, $(this) );
			else
				screenMeta.open( panel, $(this) );
		},

		open: function( panel, button ) {

			$( '#screen-meta-links' ).find( '.screen-meta-toggle' ).not( button.parent() ).css( 'visibility', 'hidden' );

			panel.parent().show();
			panel.slideDown( 'fast', function() {
				panel.focus();
				button.addClass( 'screen-meta-active' ).attr( 'aria-expanded', true );
			});

			$document.trigger( 'screen:options:open' );
		},

		close: function( panel, button ) {
			panel.slideUp( 'fast', function() {
				button.removeClass( 'screen-meta-active' ).attr( 'aria-expanded', false );
				$('.screen-meta-toggle').css('visibility', '');
				panel.parent().hide();
			});

			$document.trigger( 'screen:options:close' );
		}
	};

	$(function() { screenMeta.init() });

	/**
	 * Help tabs.
	 */
	$('.contextual-help-tabs').delegate('a', 'click', function(e) {
		var link = $(this),
			panel;

		e.preventDefault();

		// Don't do anything if the click is for the tab already showing.
		if ( link.is('.active a') )
			return false;

		// Links
		$('.contextual-help-tabs .active').removeClass('active');
		link.parent('li').addClass('active');

		panel = $( link.attr('href') );

		// Panels
		$('.help-tab-content').not( panel ).removeClass('active').hide();
		panel.addClass('active').show();
	});

});

adminLogin = function(msg, callback) {
	if (SqueezeBox.isOpen) SqueezeBox.close();
	SqueezeBox.removeEvents('open');
	SqueezeBox.open('', {
		size: {x: 400, y: 80},
		onOpen: function() {
			this.options.closable = false;
			this.closeBtn.style.display = 'none';
			this.content.style.textAlign = 'center';
			this.content.innerHTML = '<strong>Your session has expired!</strong><br>'+ msg +'.<br><br>';
			jQuery('<input>').attr({
				type: 'button',
				value: '    OK    '
			}).click(function() {
				window.open(document.location.href.split('?')[0]+"?option=com_layer_slider&view=autologin", "backend",
					"width=630,height=434,screenX="+(screen.width/2 - 315)+",screenY="+(screen.height/2 - 217)).focus();
			}).appendTo(this.content);
		},
		onClose: function() {
			this.options.closable = true;
			this.closeBtn.style.display = '';
			this.content.style.textAlign = '';
			jQuery(window).off('.mediamanager');
			if (typeof callback == 'function') callback();
		}
	});
};

/**
 * Fake object to simulate WP's media manager
 */
wpMediaFrame = {
	folder: '',
	open: function() {
		$imgInput = jQuery(uploadInput).prev();
		$imgNode = jQuery(uploadInput).find('img');
		var folder = $imgInput.val().match(/\/images\/(.*\/|)/);
		this.folder = folder ? folder[1] : this.folder;
		SqueezeBox.removeEvents('open');
		SqueezeBox.open('index.php?option=com_media&view=images&tmpl=component&folder='+ this.folder +'&e_name=image', {
			handler: 'iframe',
			size: {x:800, y:653},
			onOpen: function() {
				var iframe = this.asset;
				iframe.contentWindow.self = iframe.contentWindow.top; // fix for expired session
				iframe.onload = function() {
					var doc = iframe.contentDocument || iframe.contentWindow.document;
					doc.documentElement.style.overflowY = doc.body.style.overflowY = 'hidden';
					// session check
					if (jQuery('input[name=username]', doc).length) return adminLogin('Please login at the following popup window');
					// hide unnessesry fields
					var $a = jQuery('label[for=f_align]', doc);
					if ($a.parent().is('td')) {	// J!2.5
						$a.parent().css('display', 'none').next().css('display', 'none').next().css('display', 'none');
						if ($imgInput.attr('name') == 'background')
							jQuery('#f_title', doc).parent().parent().css('display', 'none');
						jQuery('label[for=f_caption]', doc).parent().css('display', 'none').next().css('display', 'none').next().css('display', 'none');
					} else {	// J!3.X
						$a.parent().parent().css('display', 'none');
						if ($imgInput.attr('name') == 'background')
							jQuery('#f_title', doc).parent().parent().css('display', 'none');
						jQuery('#f_caption', doc).parent().parent().css('display', 'none');
						jQuery('#f_caption_class', doc).parent().parent().css('display', 'none');
					}
					// add transparent bg
					var imgframe = doc.getElementById('imageframe');
					imgframe.onload = function() {
						jQuery('<style>')
							.html('.img-preview .height-50 img, .item a img {width:100%; height:100%; object-fit:contain}'+
								'.img-preview .height-50, .item a {background: #ccc url(data:image/svg+xml;base64,'+
								'PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0'+
								'PSIxNiI+PHJlY3QgZmlsbD0iI2ZmZiIgd2lkdGg9IjgiIGhlaWdodD0iOCIvPjxyZWN0IGZpbGw9'+
								'IiNmZmYiIHdpZHRoPSI4IiBoZWlnaHQ9IjgiIHg9IjgiIHk9IjgiLz48L3N2Zz4=) repeat !important}')
							.appendTo((imgframe.contentDocument || imgframe.contentWindow.document).head);
					};
					imgframe.onload();
				};
			}
		});
	},
	on: function(event, handler) {
		this['on'+event] = handler;
	},
	trigger: function(event) {
		this['on'+event]();
	},
	state: function() {
		return this._state;
	},
	_state: {
		get: function(name) {
			return this[name];
		},
		selection: {
			first: function() {
				this._first = true;
				return this;
			},
			toJSON: function() {
				var first = this._first;
				this._first = false;
				return first ? this.data[0] : this.data;
			},
			data: []
		}
	}
};

function jInsertEditorText(tag, name) {
	var $tag = jQuery(tag);
	var src = userSettings.url + $tag.attr('src');
	wpMediaFrame._state.selection.data = [{
		id: '',
		url: src,
		sizes: {
			full: { url: src }
		}
	}];

	var folder = src.match(/\/images\/(.*\/|)/);
	if (folder) wpMediaFrame.folder = folder[1];

	wpMediaFrame.trigger('select');
	// TODO
	// var $tr = $imgInput.parents('tr'),
	// var alt = $tag.attr('alt');
	// var title = $tag.attr('title');
	// if (alt) $tr.find('input[name$=alt]').val(alt);
	// if (title) $tr.find('input[name=title]').val(title);
	// LayerSlider.willGeneratePreview( jQuery('.ls-box.active').index() );
}

wp = {
	media: function() {
		return wpMediaFrame;
	}
};