<?php
/*-------------------------------------------------------------------------
# mod_layer_slider - Layer Slider
# -------------------------------------------------------------------------
# @ author    John Gera, George Krupa, Janos Biro, Balint Polgarfi
# @ copyright Copyright (C) 2017 Offlajn.com  All Rights Reserved.
# @ license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# @ website   http://www.offlajn.com
-------------------------------------------------------------------------*/
namespace LayerSlider;

defined('_JEXEC') or die;
?><?php

global $ls_load_module;
require_once JPATH_ADMINISTRATOR.'/components/com_layer_slider/helpers/wp_helper.php';
require_once __DIR__.'/layer_slider_helper.php';

$id = $params->get('slider', 0);
if ($ls_load_module) {
	ob_start();
	layerslider($id);
	$data = ob_get_clean();
	echo \JHtml::_('content.prepare', $data);
} else {
	layerslider($id);
}

// dynamic google font loading
ls_add_google_fonts();

// Conditionally load LayerSlider plugins
if( ! empty( $GLOBALS['lsLoadPlugins'] ) ) {

	// Filter out duplicates
	$GLOBALS['lsLoadPlugins'] = array_unique($GLOBALS['lsLoadPlugins']);

	// Load plugins
	foreach( $GLOBALS['lsLoadPlugins'] as $item ) {
		wp_enqueue_script('layerslider-'.$item);
		wp_enqueue_style('layerslider-'.$item);
	}
}