<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_custom
 *
 * @copyright   Copyright (C) 2005 - 2016 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
?>

<ul class="nav menu">

<?php

    $m = JFactory::getApplication()->getMenu();

    $active = $m->getActive();
    $active_id = isset($active) ? $active->id : $m->getDefault()->id;
    $path   = isset($active) ? $active->tree : array();

    $menu = $m->getMenu();

    $parentId = $params->get("menuitem");
    foreach($menu as $item){
        if($item->level == 2 && $item->parent_id == $parentId){
            $class = 'item-'.$item->id;
            if ($item->id == $active_id) {
                $class .= ' current';
            }
            if (in_array($item->id, $path)) {
                $class .= ' active';
            }

            $flink = $item->link;
            if ((strpos($item->link, 'index.php?') === 0) && (strpos($item->link, 'Itemid=') === false)) {
                $item->flink = $item->link.'&Itemid='.$item->id;

                if (strcasecmp(substr($item->flink, 0, 4), 'http') && (strpos($item->flink, 'index.php?') !== false)) {
                    $item->flink = JRoute::_($item->flink, true, $item->params->get('secure'));
                }
                else {
                    $item->flink = JRoute::_($item->flink);
                }
            }
            echo "<li class='$class'><a href='$item->flink'>$item->title</a></li>";
        }
    }
    ?>

</ul>